/* 
* ======  ======
*
* : Auto Config
* : Sho0ter
* : 1.0
*  : 20.04.2010
*  : http://cs.4m.net.ua
*
* ========  ========
*
*       .
*  ,   ,   ..
*     :
* <moddir>/addons/amxmodx/configs/autoconfig/<mapname>.ini
*
* =======  =======
*
* amx_autoconfig <0/1> [ : 1]
*	-  
*	- 0 
*	- 1 
*
* amx_autoconfig_delay <> [ : 5.0]
*	- ,    
*
* amx_autoconfig_mapconfig <0/1> [ : 1]
*	-     
*	- 0 
*	- 1 
*
* amx_autoconfig_echo <0/1> [ : 1]
*	-      
*	- 0 
*	- 1 
*
* ===========================
*/

#include <amxmodx>
#include <amxmisc>

#define PLUGIN "Auto Config"
#define VERSION "1.0"
#define AUTHOR "Sho0ter"

new configfile[128], configsdir[64], buffer[128], map[64]
new index, len, configfilesize

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("amx_autoconfig", "1")
	register_cvar("amx_autoconfig_delay", "5.0")
	register_cvar("amx_autoconfig_mapconfig", "1")
	register_cvar("amx_autoconfig_echo", "1")
	return PLUGIN_CONTINUE
}

public client_putinserver(id)
{
	if(get_cvar_num("amx_autoconfig") == 1)
	{
		set_task(get_cvar_float("amx_autoconfig_delay"), "config_user", id)
	}
	return PLUGIN_CONTINUE
}

public config_user(id)
{
	get_configsdir(configsdir, 63)
	formatex(configfile, 127, "%s/autoconfig.ini", configsdir)
	if(file_exists(configfile))
	{
		client_cmd(id, "echo Start set configuration...")
		configfilesize = file_size(configfile, 1)
		index = 0	
		while(index <= configfilesize)
		{
			read_file(configfile, index, buffer, sizeof(buffer)-1, len)
			client_cmd(id, "%s", buffer)
			if(get_cvar_num("amx_autoconfig_echo") == 1)
			{
				client_cmd(id, "echo %s", buffer)
			}
			index++
		}
		client_cmd(id, "echo Done.")
	}
	else
	{
		server_print("[Auto Config] Could not find config file: %s", configfile)
	}
	if(get_cvar_num("amx_autoconfig_mapconfig") == 1)
	{
		get_mapname(map, 63)
		formatex(configfile, 127, "%s/autoconfig/%s.ini", configsdir, map)
		if(file_exists(configfile))
		{
			client_cmd(id, "echo Start set map-configuration...")
			configfilesize = file_size(configfile, 1)
			index = 0	
			while(index <= configfilesize)
			{
				read_file(configfile, index, buffer, sizeof(buffer)-1, len)
				client_cmd(id, "%s", buffer)
				if(get_cvar_num("amx_autoconfig_echo") == 1)
				{
					client_cmd(id, "echo %s", buffer)
				}
				index++
			}
			client_cmd(id, "echo Done.")
		}
		else
		{
			server_print("[Auto Config] Map-config file not found: %s", configfile)
		}
	}
	return PLUGIN_CONTINUE
}

public client_disconnect(id) 
{
	remove_task(id)
	return PLUGIN_CONTINUE
}